/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCAxis;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLineStyle;
import jclass.chart.JCSymbolStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class PlotChartDraw
extends ChartDraw {
    PlotPoint[][][] pts;
    Point[][] ptsIndex;
    Point prev;
    Point next;
    Point last;
    Rectangle r;
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;

    public PlotChartDraw(ChartDataView chartDataView) {
        super(chartDataView);
    }

    public void recalc() {
        super.recalc();
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        boolean bl = this.dataObject.xaxis.isVertical;
        MinMax minMax = new MinMax();
        MinMax minMax2 = new MinMax();
        this.dataObject.getDataBounds(minMax, minMax2);
        this.pts = new PlotPoint[chartDataViewSeriesArray.length][][];
        this.ptsIndex = new Point[chartDataViewSeriesArray.length][];
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            ChartDataViewSeries chartDataViewSeries = chartDataViewSeriesArray[n];
            this.pts[n] = null;
            this.ptsIndex[n] = null;
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                int n2 = Math.min(chartDataViewSeries.maxXIndex(), chartDataViewSeries.maxYIndex());
                this.pts[n] = new PlotPoint[n2][];
                this.ptsIndex[n] = new Point[n2];
                double d = 0.0;
                double d2 = this.dataObject.holeValue;
                boolean bl2 = false;
                int n3 = 0;
                int n4 = 0;
                this.pts[n][n3] = new PlotPoint[n2 + 1];
                int n5 = chartDataViewSeries.getFirstPoint();
                while (n5 <= chartDataViewSeries.getLastPoint()) {
                    double d3 = chartDataViewSeries.getX(n5);
                    double d4 = chartDataViewSeries.getY(n5);
                    bl2 = this.plotClip(d, d2, d3, d4, minMax, minMax2, this.pts[n][n3], n5, n4, bl2, bl);
                    if (this.pts[n][n3][n4] != null) {
                        this.ptsIndex[n][this.pts[n][n3][n4].point] = new Point(n3, n4);
                        ++n4;
                    }
                    if (this.pts[n][n3][n4] != null) {
                        this.ptsIndex[n][this.pts[n][n3][n4].point] = new Point(n3, n4);
                        ++n4;
                    }
                    if (!bl2 && this.pts[n][n3][0] != null) {
                        this.pts[n][++n3] = new PlotPoint[n2];
                        this.pts[n][n3][0] = new PlotPoint();
                        n4 = 0;
                    }
                    d = d3;
                    d2 = d4;
                    ++n5;
                }
            }
            ++n;
        }
    }

    public void draw(Graphics graphics) {
        try {
            ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
            if (this.pts == null) {
                return;
            }
            int n = 0;
            while (n < this.pts.length) {
                if (this.pts[n] != null) {
                    JCChartStyle jCChartStyle;
                    ChartDataViewSeries chartDataViewSeries = chartDataViewSeriesArray[n];
                    if (chartDataViewSeries.isShowing && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                        int n2 = 0;
                        while (n2 < this.pts[n].length) {
                            if (this.pts[n][n2] != null) {
                                Point point = null;
                                int n3 = 0;
                                while (n3 < this.pts[n][n2].length) {
                                    if (this.pts[n][n2][n3] == null || this.pts[n][n2][n3].px == Integer.MAX_VALUE || this.pts[n][n2][n3].py == Integer.MAX_VALUE) {
                                        point = null;
                                    } else {
                                        Point point2 = new Point(this.pts[n][n2][n3].px, this.pts[n][n2][n3].py);
                                        if (point != null && this.chartType == 0) {
                                            jCLineStyle.draw(graphics, point.x, point.y, point2.x, point2.y);
                                        }
                                        if (this.pts[n][n2][n3].drawPoint) {
                                            jCSymbolStyle.draw(graphics, point2.x, point2.y);
                                        }
                                        point = point2;
                                    }
                                    ++n3;
                                }
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (this.pts[n5] != null && chartDataViewSeriesArray[n5].isShowing) {
                int n6 = 0;
                while (n6 < this.pts[n5].length) {
                    if (this.pts[n5][n6] != null) {
                        int n7 = 0;
                        while (n7 < this.pts[n5][n6].length) {
                            if (this.pts[n5][n6][n7] != null && this.pts[n5][n6][n7].px != Integer.MAX_VALUE && this.pts[n5][n6][n7].py != Integer.MAX_VALUE && this.pts[n5][n6][n7].drawPoint) {
                                int n8 = Integer.MAX_VALUE;
                                switch (n) {
                                    case 1: {
                                        n8 = Math.abs(this.pts[n5][n6][n7].px - point2.x);
                                        break;
                                    }
                                    case 2: {
                                        n8 = Math.abs(this.pts[n5][n6][n7].py - point2.y);
                                        break;
                                    }
                                    default: {
                                        n8 = JCChartUtil.distance(point2.x, point2.y, this.pts[n5][n6][n7].px, this.pts[n5][n6][n7].py);
                                    }
                                }
                                if (n8 < n4) {
                                    n2 = n5;
                                    n3 = this.pts[n5][n6][n7].point;
                                    n4 = n8;
                                }
                            }
                            ++n7;
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, chartDataViewSeriesArray[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.dataObject.getSeries(n2);
        boolean bl = this.dataObject.xaxis.isVertical;
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.dataObject.holeValue && d2 != this.dataObject.holeValue) {
            if (bl) {
                n3 = this.dataObject.yaxis.toPixel(d);
                n4 = this.dataObject.xaxis.toPixel(d2);
            } else {
                n3 = this.dataObject.xaxis.toPixel(d2);
                n4 = this.dataObject.yaxis.toPixel(d);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.drawingOrder;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n2 = this.ptsIndex[n][jCDataIndex.point].x;
        int n3 = this.ptsIndex[n][jCDataIndex.point].y;
        PlotPoint[] plotPointArray = this.pts[n][n2];
        if (n3 - 1 >= 0 && plotPointArray[n3 - 1] != null && plotPointArray[n3 - 1].px != Integer.MAX_VALUE && plotPointArray[n3 - 1].py != Integer.MAX_VALUE) {
            this.prev = new Point(plotPointArray[n3 - 1].px + this.r.x, plotPointArray[n3 - 1].py + this.r.y);
        }
        if (n3 + 1 < plotPointArray.length && plotPointArray[n3 + 1] != null && plotPointArray[n3 + 1].px != Integer.MAX_VALUE && plotPointArray[n3 + 1].py != Integer.MAX_VALUE) {
            this.next = new Point(plotPointArray[n3 + 1].px + this.r.x, plotPointArray[n3 + 1].py + this.r.y);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n, jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point)) + this.r.y) : new Point(jCDataIndex.dataView.xaxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point)) + this.r.x, n2);
        } else if (bl) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    boolean plotClip(double d, double d2, double d3, double d4, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        double d5 = minMax.min;
        double d6 = minMax.max;
        double d7 = minMax2.min;
        double d8 = minMax2.max;
        JCAxis jCAxis = this.dataObject.getXAxis();
        JCAxis jCAxis2 = this.dataObject.getYAxis();
        boolean bl3 = true;
        boolean bl4 = true;
        int n4 = n - 1;
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!bl) {
            if (d2 == this.dataObject.holeValue || d == this.dataObject.holeValue) {
                n6 = 1;
                bl6 = false;
                bl5 = true;
            } else {
                n6 = JCChartUtil.locateXY(d, d2, d5, d6, d7, d8);
            }
        }
        if (d4 == this.dataObject.holeValue || d3 == this.dataObject.holeValue) {
            n7 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n7 = JCChartUtil.locateXY(d3, d4, d5, d6, d7, d8);
        }
        int n8 = n6;
        int n9 = n7;
        while (bl6 && !this.acceptPoint(n8, n9) && !this.rejectPoint(n8, n9)) {
            double d9;
            double d10;
            int n10 = n3 = n8 != 0 ? n8 : n9;
            if ((n3 & 1) != 0) {
                d10 = d2 + (d4 - d2) * (d5 - d) / (d3 - d);
                d9 = d5;
                n3 = JCChartUtil.locateY(d10, d7, d8);
            } else if ((n3 & 2) != 0) {
                d10 = d2 + (d4 - d2) * (d6 - d) / (d3 - d);
                d9 = d6;
                n3 = JCChartUtil.locateY(d10, d7, d8);
            } else if ((n3 & 4) != 0) {
                d9 = d + (d3 - d) * (d7 - d2) / (d4 - d2);
                d10 = d7;
                n3 = JCChartUtil.locateX(d9, d5, d6);
            } else {
                d9 = d + (d3 - d) * (d8 - d2) / (d4 - d2);
                d10 = d8;
                n3 = JCChartUtil.locateX(d9, d5, d6);
            }
            if (n8 != 0) {
                n8 = n3;
                d = d9;
                d2 = d10;
                bl3 = false;
                continue;
            }
            n9 = n3;
            d3 = d9;
            d4 = d10;
            bl4 = false;
        }
        int n11 = n3 = n2 != 0 || !bl5 || n6 != 0 && n7 != 0 ? 0 : 1;
        if (this.acceptPoint(n8, n9) || n3 != 0) {
            if (bl) {
                if (!bl5) {
                    plotPointArray[n2] = new PlotPoint();
                    if (bl2) {
                        plotPointArray[n2].px = jCAxis2.toPixel(d4);
                        plotPointArray[n2].py = jCAxis.toPixel(d3);
                    } else {
                        plotPointArray[n2].px = jCAxis.toPixel(d3);
                        plotPointArray[n2].py = jCAxis2.toPixel(d4);
                    }
                    bl = n7 == 0 && n2 < plotPointArray.length;
                    plotPointArray[n2].drawPoint = bl4;
                    plotPointArray[n2].point = n5;
                } else {
                    bl = false;
                    plotPointArray[n2] = null;
                }
            } else {
                if (n3 != 0 && n7 == 0) {
                    d = d3;
                    d2 = d4;
                    bl3 = bl4;
                    n4 = n5;
                }
                plotPointArray[n2] = new PlotPoint();
                if (bl2) {
                    plotPointArray[n2].px = jCAxis2.toPixel(d2);
                    plotPointArray[n2].py = jCAxis.toPixel(d);
                } else {
                    plotPointArray[n2].px = jCAxis.toPixel(d);
                    plotPointArray[n2].py = jCAxis2.toPixel(d2);
                }
                plotPointArray[n2].drawPoint = bl3;
                plotPointArray[n2].point = n4;
                if (n3 == 0) {
                    plotPointArray[n2 + 1] = new PlotPoint();
                    if (bl2) {
                        plotPointArray[n2 + 1].px = jCAxis2.toPixel(d4);
                        plotPointArray[n2 + 1].py = jCAxis.toPixel(d3);
                    } else {
                        plotPointArray[n2 + 1].px = jCAxis.toPixel(d3);
                        plotPointArray[n2 + 1].py = jCAxis2.toPixel(d4);
                    }
                    plotPointArray[n2 + 1].drawPoint = bl4;
                    plotPointArray[n2 + 1].point = n5;
                }
                bl = n7 == 0;
            }
        } else {
            plotPointArray[n2] = null;
            bl = false;
        }
        return bl;
    }

    boolean acceptPoint(int n, int n2) {
        return (n | n2) == 0;
    }

    boolean rejectPoint(int n, int n2) {
        return (n & n2) != 0;
    }
}

